/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.fluid;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.NetworkFactory;
import com.refinedmods.refinedpipes.network.fluid.FluidNetwork;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipeType;
import com.refinedmods.refinedpipes.util.StringUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidNetworkFactory
implements NetworkFactory {
    private static final Logger LOGGER = LogManager.getLogger(FluidNetworkFactory.class);
    private final FluidPipeType pipeType;

    public FluidNetworkFactory(FluidPipeType pipeType) {
        this.pipeType = pipeType;
    }

    @Override
    public Network create(BlockPos pos) {
        return new FluidNetwork(pos, StringUtil.randomString(new Random(), 8), this.pipeType);
    }

    @Override
    public Network create(CompoundTag tag) {
        FluidNetwork network = new FluidNetwork(BlockPos.m_122022_((long)tag.m_128454_("origin")), tag.m_128461_("id"), this.pipeType);
        if (tag.m_128441_("tank")) {
            network.getFluidTank().readFromNBT(tag.m_128469_("tank"));
        }
        LOGGER.debug("Deserialized fluid network {} of type {}", (Object)network.getId(), (Object)network.getType().toString());
        return network;
    }
}

